/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.ui.editor.formatting;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.contentassist.ILexemeProvider;
import com.aptana.editor.php.PHPEditorPlugin;
import com.aptana.editor.php.epl.PHPEplPlugin;
import com.aptana.editor.php.internal.contentAssist.PHPTokenType;
import com.aptana.editor.php.internal.contentAssist.ParsingUtils;
import com.aptana.editor.php.internal.ui.editor.PHPSourceViewerConfiguration;
import com.aptana.parsing.lexer.Lexeme;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.ISourceViewer;

public class AbstractPHPAutoEditStrategy
implements IAutoEditStrategy {
    protected static Set<String> ALTERNATIVE_END_STYLES = new HashSet<String>(Arrays.asList("PHP_ENDDECLARE", "PHP_ENDFOR", "PHP_ENDFOREACH", "PHP_ENDIF", "PHP_ENDSWITCH", "PHP_ENDWHILE"));
    protected static Set<String> ALTERNATIVE_START_STYLES = new HashSet<String>(Arrays.asList("PHP_DECLARE", "PHP_FOR", "PHP_FOREACH", "PHP_IF", "PHP_SWITCH", "PHP_WHILE"));
    protected static Set<String> BLOCK_TYPES = new HashSet<String>(Arrays.asList("PHP_IF", "PHP_FOR", "PHP_FOREACH", "PHP_ELSEIF", "PHP_ELSE", "PHP_SWITCH", "PHP_WHILE", "PHP_CASE", "PHP_DEFAULT"));
    protected static Set<String> TERMINATORS = new HashSet<String>(Arrays.asList("PHP_FUNCTION", "PHP_CLASS", "PHP_PUBLIC", "PHP_PROTECTED", "PHP_PRIVATE"));
    protected static Map<String, String> PAIR_MATCH = new HashMap<String, String>();
    protected static final int MAX_CHARS_TO_LEX_BACK = 1000;
    protected String spaces = "                                                                            ";
    protected ILexemeProvider<PHPTokenType> lexemeProvider;
    protected String contentType;
    protected PHPSourceViewerConfiguration configuration;
    protected ISourceViewer sourceViewer;

    static {
        PAIR_MATCH.put("PHP_ENDIF", "PHP_IF");
        PAIR_MATCH.put("PHP_ENDDECLARE", "PHP_DECLARE");
        PAIR_MATCH.put("PHP_ENDFOR", "PHP_FOR");
        PAIR_MATCH.put("PHP_ENDFOREACH", "PHP_FOREACH");
        PAIR_MATCH.put("PHP_ENDSWITCH", "PHP_SWITCH");
        PAIR_MATCH.put("PHP_ENDWHILE", "PHP_WHILE");
    }

    public AbstractPHPAutoEditStrategy(String contentType, PHPSourceViewerConfiguration configuration, ISourceViewer sourceViewer) {
        this.contentType = contentType;
        this.configuration = configuration;
        this.sourceViewer = sourceViewer;
    }

    protected ILexemeProvider<PHPTokenType> getLexemeProvider(IDocument document, int offset, boolean includeOtherPartitions) {
        if (this.lexemeProvider == null) {
            this.lexemeProvider = includeOtherPartitions ? ParsingUtils.createLexemeProvider(document, Math.max(0, offset - 1000), offset) : ParsingUtils.createLexemeProvider(document, offset);
        }
        return this.lexemeProvider;
    }

    protected void setLexemeProvider(ILexemeProvider<PHPTokenType> lexemeProvider) {
        this.lexemeProvider = lexemeProvider;
    }

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        char current;
        if (command.text == null || command.length > 0 || !this.isAutoIndentEnabled()) {
            return;
        }
        String[] lineDelimiters = document.getLegalLineDelimiters();
        int index = TextUtilities.endsWith((String[])lineDelimiters, (String)command.text);
        if (index > -1) {
            if (lineDelimiters[index].equals(command.text)) {
                this.indentAfterNewLine(document, command);
            }
            return;
        }
        if (command.text.length() == 1 && this.isAutoInsertCharacter(command.text.charAt(0)) && this.isAutoInsertEnabled() && this.isValidAutoInsertLocation(document, command) && this.overwriteBracket(current = command.text.charAt(0), document, command)) {
            return;
        }
    }

    protected void matchIndent(IDocument document, StringBuilder indentationBuffer, int lineNumber, int offset, Set<String> sameIndentItems, Set<String> lowerIndentItems) throws BadLocationException {
        IRegion currentLineInfo = document.getLineInformationOfOffset(offset);
        int lineStartOffset = currentLineInfo.getOffset();
        if (lineStartOffset == 0) {
            return;
        }
        do {
            Lexeme<PHPTokenType> firstLexemeInLine;
            if ((firstLexemeInLine = this.getFirstLexemeInLine(document, this.lexemeProvider, lineStartOffset = (currentLineInfo = document.getLineInformationOfOffset(lineStartOffset - 1)).getOffset())) == null) continue;
            String type = ((PHPTokenType)firstLexemeInLine.getType()).getType();
            if (TERMINATORS.contains(type)) {
                return;
            }
            String pairToFind = null;
            pairToFind = "}".equals(firstLexemeInLine.getText()) ? "{" : this.getLexemePair(firstLexemeInLine);
            if (pairToFind == null) {
                if (sameIndentItems != null && sameIndentItems.contains(type)) {
                    indentationBuffer.append(this.getIndentationAtOffset(document, firstLexemeInLine.getStartingOffset()));
                    return;
                }
                if (lowerIndentItems == null || !lowerIndentItems.contains(type)) continue;
                String indent = this.getIndentationAtOffset(document, firstLexemeInLine.getStartingOffset());
                indent = String.valueOf(indent) + this.configuration.getIndent();
                indentationBuffer.append(indent);
                return;
            }
            lineStartOffset = this.getPervPairMatchOffset(pairToFind, currentLineInfo.getOffset(), document);
            if (lineStartOffset <= 0) continue;
            ++lineStartOffset;
        } while (lineStartOffset > 0);
    }

    protected int getPervPairMatchOffset(String pairToFind, int offset, IDocument document) throws BadLocationException {
        Stack<String> stack = new Stack<String>();
        stack.push(pairToFind);
        Lexeme lexeme = this.lexemeProvider.getFloorLexeme(offset);
        while (!stack.isEmpty() && lexeme != null && lexeme.getStartingOffset() > 0) {
            String type = ((PHPTokenType)lexeme.getType()).getType();
            String nextToMatch = (String)stack.peek();
            if (nextToMatch.equals(type) || nextToMatch.equals(lexeme.getText())) {
                if (stack.size() == 1) {
                    IRegion lexemeLine = document.getLineInformationOfOffset(lexeme.getStartingOffset());
                    return lexemeLine.getOffset();
                }
                stack.pop();
            } else if ("}".equals(lexeme.getText())) {
                stack.push("{");
            } else {
                String pair = this.getLexemePair((Lexeme<PHPTokenType>)lexeme);
                if (pair != null) {
                    stack.push(pair);
                }
            }
            lexeme = this.lexemeProvider.getFloorLexeme(lexeme.getStartingOffset() - 1);
        }
        return -1;
    }

    protected Lexeme<PHPTokenType> getPreviousNonWhitespaceLexeme(int offset) {
        int index = this.lexemeProvider.getLexemeFloorIndex(offset);
        Lexeme lexeme = this.lexemeProvider.getLexeme(index);
        while (lexeme != null && "WHITESPACE".equals(((PHPTokenType)lexeme.getType()).getType()) && index > 0) {
            lexeme = this.lexemeProvider.getLexeme(--index);
        }
        if (lexeme != null && !"WHITESPACE".equals(((PHPTokenType)lexeme.getType()).getType())) {
            return lexeme;
        }
        return null;
    }

    protected String getLexemePair(Lexeme<PHPTokenType> lexeme) {
        return PAIR_MATCH.get(((PHPTokenType)lexeme.getType()).getType());
    }

    protected boolean isValidAutoInsertLocation(IDocument document, DocumentCommand command) {
        return true;
    }

    public boolean overwriteBracket(char bracket, IDocument document, DocumentCommand command) {
        if (this.canOverwriteBracket(bracket, command.offset, document)) {
            command.text = "";
            command.shiftsCaret = false;
            command.caretOffset = command.offset + 1;
            return true;
        }
        return false;
    }

    protected Lexeme<PHPTokenType> getFirstLexemeInLine(IDocument document, ILexemeProvider<PHPTokenType> lexemeProvider, int offset) throws BadLocationException {
        if (offset < 0) {
            return null;
        }
        IRegion lineRegion = document.getLineInformationOfOffset(offset);
        Lexeme lexeme = lexemeProvider.getCeilingLexeme(lineRegion.getOffset());
        if (lexeme == null || !"WHITESPACE".equals(((PHPTokenType)lexeme.getType()).getType())) {
            return lexeme;
        }
        int index = lexemeProvider.getLexemeIndex(lexeme.getStartingOffset());
        if (index + 1 < lexemeProvider.size() && (lexeme = lexemeProvider.getLexeme(index + 1)).getStartingOffset() < lineRegion.getOffset() + lineRegion.getLength()) {
            return lexeme;
        }
        return null;
    }

    protected Lexeme<PHPTokenType> getLastLexemeInLine(IDocument document, ILexemeProvider<PHPTokenType> lexemeProvider, int offset) throws BadLocationException {
        Lexeme lexeme;
        IRegion lineRegion = document.getLineInformationOfOffset(offset);
        int lastCharInLine = lineRegion.getOffset() + lineRegion.getLength();
        if (lineRegion.getLength() > 0) {
            --lastCharInLine;
        }
        if ((lexeme = lexemeProvider.getFloorLexeme(lastCharInLine)) == null || !"WHITESPACE".equals(((PHPTokenType)lexeme.getType()).getType())) {
            return lexeme;
        }
        int index = lexemeProvider.getLexemeIndex(lexeme.getStartingOffset());
        if (index - 1 > 0 && (lexeme = lexemeProvider.getLexeme(index - 1)).getStartingOffset() > lineRegion.getOffset()) {
            return lexeme;
        }
        return null;
    }

    protected Lexeme<PHPTokenType> getFirstLexemeInNonEmptyLine(IDocument document, ILexemeProvider<PHPTokenType> lexemeProvider, int offset) throws BadLocationException {
        IRegion lineInfo = null;
        Lexeme<PHPTokenType> lexeme = null;
        do {
            lineInfo = document.getLineInformationOfOffset(offset);
            lexeme = this.getFirstLexemeInLine(document, lexemeProvider, lineInfo.getOffset() - 1);
            if (lineInfo == null) continue;
            offset = lineInfo.getOffset() - 1;
        } while (lexeme == null && lineInfo != null && lineInfo.getOffset() > 0 && offset > 0);
        return lexeme;
    }

    public boolean canOverwriteBracket(char bracket, int offset, IDocument document) {
        if (offset < document.getLength()) {
            char[] autoOverwriteChars = this.getAutoOverwriteCharacters();
            Arrays.sort(autoOverwriteChars);
            if (Arrays.binarySearch(autoOverwriteChars, bracket) < 0) {
                return false;
            }
            try {
                char sibling = document.getChar(offset);
                return sibling == bracket;
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }
        return false;
    }

    protected char[] getAutoOverwriteCharacters() {
        return new char[]{')', '>', ']', '\"', '\'', '}'};
    }

    protected boolean isAutoInsertEnabled() {
        return true;
    }

    protected boolean isAutoIndentEnabled() {
        return PHPEplPlugin.getDefault().getPreferenceStore().getBoolean("com.aptana.editor.common.autoIndent");
    }

    protected void indentAfterNewLine(IDocument d, DocumentCommand c) {
        String indentString = this.configuration.getIndent();
        if (indentString.equals("")) {
            return;
        }
        int offset = c.offset;
        if (offset == -1 || d.getLength() == 0) {
            return;
        }
        c.text = String.valueOf(c.text) + this.getIndentationAtOffset(d, offset);
    }

    protected String getIndentationAtOffset(IDocument d, int offset) {
        String indentation = "";
        try {
            int p = offset == d.getLength() ? offset - 1 : offset;
            IRegion line = d.getLineInformationOfOffset(p);
            int lineOffset = line.getOffset();
            int firstNonWS = this.findEndOfWhiteSpace(d, lineOffset, offset);
            indentation = this.getIndentationString(d, lineOffset, firstNonWS);
        }
        catch (BadLocationException excp) {
            IdeLog.logWarning((Plugin)PHPEditorPlugin.getDefault(), (String)"PHP Auto Edit Strategy - Bad location while computing the indentation at offset (getIndentationAtOffset)", (Throwable)excp, (String)"com.aptana.editor.php/debug");
        }
        return indentation;
    }

    protected int findEndOfWhiteSpace(IDocument document, int offset, int end) throws BadLocationException {
        while (offset < end) {
            char c = document.getChar(offset);
            if (c != ' ' && c != '\t') {
                return offset;
            }
            ++offset;
        }
        return end;
    }

    private boolean isAutoInsertCharacter(char c) {
        int val = Arrays.binarySearch(this.getAutoInsertCharacters(), c);
        return val >= 0;
    }

    protected char[] getAutoInsertCharacters() {
        return new char[]{'(', '<', '[', '\"', '\'', '{'};
    }

    protected String getIndentationString(IDocument d, int lineOffset, int firstNonWS) {
        int indentStringWidth;
        String lineIndent = "";
        try {
            lineIndent = d.get(lineOffset, firstNonWS - lineOffset);
        }
        catch (BadLocationException e1) {
            IdeLog.logWarning((Plugin)PHPEditorPlugin.getDefault(), (String)"PHP Auto Edit Strategy - Bad location while computing a line indentation (getIndentationString)", (Throwable)e1, (String)"com.aptana.editor.php/debug");
        }
        if (lineIndent.equals("")) {
            return lineIndent;
        }
        int indentSize = 0;
        int tabWidth = Math.max(1, this.configuration.getTabWidth(this.sourceViewer));
        char[] indentChars = lineIndent.toCharArray();
        int i = 0;
        while (i < indentChars.length) {
            char e = indentChars[i];
            indentSize = e == '\t' ? (indentSize += tabWidth - indentSize % tabWidth) : ++indentSize;
            ++i;
        }
        String indentString = this.configuration.getIndent();
        int n = indentStringWidth = indentString.equals("\t") ? tabWidth : indentString.length();
        if (indentStringWidth == 0) {
            return "";
        }
        int indentCount = (int)Math.floor(indentSize / indentStringWidth);
        StringBuilder indentation = new StringBuilder();
        int i2 = 0;
        while (i2 < indentCount) {
            indentation.append(indentString);
            ++i2;
        }
        int extra = indentSize % indentStringWidth;
        indentation.append(this.spaces.substring(0, extra));
        return indentation.toString();
    }
}

